/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import tcintegrations.common.capabilities.CapabilityRegistry;
import tcintegrations.items.TCIntegrationsModifiers;
import tcintegrations.network.BotaniaSetData;
import tcintegrations.network.NetworkHandler;
import tcintegrations.util.BotaniaClientHelper;
import tcintegrations.util.BotaniaHelper;
import vazkii.botania.api.mana.ManaItemHandler;

public class TerrestrialModifier
extends Modifier {
    private static final int MANA_PER_DAMAGE = 70;

    public int getManaPerDamage(ServerPlayer sp) {
        return BotaniaHelper.getManaPerDamageBonus((Player)sp, 70);
    }

    @NotNull
    public Component getDisplayName(int level) {
        return this.applyStyle((MutableComponent)new TranslatableComponent(this.getTranslationKey()));
    }

    public MutableComponent applyStyle(MutableComponent component) {
        if (BotaniaClientHelper.hasTerrestrialArmorSet()) {
            return component.m_130938_(style -> style.m_131148_(this.getTextColor()));
        }
        return component.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.STRIKETHROUGH);
    }

    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> {
                boolean hasSet = this.hasArmorSetItem(sp, EquipmentSlot.HEAD) && this.hasArmorSetItem(sp, EquipmentSlot.CHEST) && this.hasArmorSetItem(sp, EquipmentSlot.LEGS) && this.hasArmorSetItem(sp, EquipmentSlot.FEET);
                data.setTerrestrial(hasSet);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new BotaniaSetData(hasSet, data.hasGreatFairy(), data.hasAlfheim()));
            });
        }
    }

    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> {
                data.setTerrestrial(false);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new BotaniaSetData(false, data.hasGreatFairy(), data.hasAlfheim()));
            });
        }
    }

    public void onInventoryTick(IToolStackView tool, int level, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        Player player;
        Player player2 = player = holder instanceof Player ? (Player)holder : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            if (itemSlot == EquipmentSlot.HEAD.m_20749_()) {
                int food;
                if (BotaniaHelper.hasTerrestrialArmorSet((Player)sp) && sp.f_19797_ % 80 == 0 && (food = sp.m_36324_().m_38702_()) > 0 && food < 18 && sp.m_36325_()) {
                    sp.m_5634_(1.0f);
                }
                if (sp.f_19797_ % 10 == 0) {
                    BotaniaHelper.dispatchManaExact(sp, 10);
                }
            }
            if (sp.f_19797_ % 20 == 0 && tool.getDamage() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, (Player)sp, this.getManaPerDamage(sp) * 2, true)) {
                tool.setDamage(tool.getDamage() - 1);
            }
        }
    }

    public boolean hasArmorSetItem(ServerPlayer sp, EquipmentSlot slot) {
        ItemStack stack = sp.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        ToolStack armor = ToolStack.from((ItemStack)stack);
        if (armor.isBroken()) {
            return false;
        }
        return armor.getUpgrades().getLevel(TCIntegrationsModifiers.TERRESTRIAL_MODIFIER.getId()) > 0;
    }
}

